// DIGITAL POTENTIOMETER PRACTICE . DEFRAN24

#include <SPI.h>  // SPI PINS: CLK-13, SDI-11, SS-10
const int CS=10;  // SS of SPI
int MON=16;

void setup() 
{
  pinMode (MON, OUTPUT);
  pinMode (CS, OUTPUT);
  SPI.begin();
  digitalWrite(MON, HIGH);
  PotWrite(0);   delay(400);
  PotWrite(63);  delay(400);
  PotWrite(127); delay(400);
  PotWrite(192); delay(400);
  PotWrite(255); delay(400);
  digitalWrite(MON, LOW);
}

void loop() 
{
  for (int i=0; i<=255; i++) 
  {
    PotWrite(i);
    delay(10);
  }
  delay(500);
  digitalWrite(MON, HIGH);
  for (int i=255; i>=0; i--) 
  {
    PotWrite(i);
    delay(10);
  }
  digitalWrite(MON, LOW);
  delay(500);
  digitalWrite(MON, LOW);
}

int PotWrite(int value) 
{
  // COMMAND BYTE: xxDCxxBA: A-POT1, B-PO2, C-POT VALUE, D-SHUTDOWN
  digitalWrite(CS, LOW);    // SS of SPI)
  SPI.transfer(0b00010001); //command
  SPI.transfer(value);      //value
  digitalWrite(CS, HIGH);   // SS OF SPI)
}
